/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.google.common.collect.ImmutableList;
import com.ninni.spawn.entity.Tuna;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TunaModel
extends AgeableListModel<Tuna> {
    public static final String LEFT_PECTORAL_FIN = "left_pectoral_fin";
    public static final String RIGHT_PECTORAL_FIN = "right_pectoral_fin";
    public static final String DORSAL_FIN = "dorsal_fin";
    public static final String DORSAL_FIN2 = "dorsal_fin2";
    public static final String PELVIC_FIN = "pelvic_fin";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart dorsalFin;
    private final ModelPart dorsalFin2;
    private final ModelPart leftPectoralFin;
    private final ModelPart rightPectoralFin;
    private final ModelPart pelvicFin;
    private final ModelPart mouth;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private final ModelPart tailFin;

    public TunaModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.dorsalFin = this.body.m_171324_(DORSAL_FIN);
        this.dorsalFin2 = this.body.m_171324_(DORSAL_FIN2);
        this.leftPectoralFin = this.body.m_171324_(LEFT_PECTORAL_FIN);
        this.rightPectoralFin = this.body.m_171324_(RIGHT_PECTORAL_FIN);
        this.pelvicFin = this.body.m_171324_(PELVIC_FIN);
        this.mouth = this.body.m_171324_("mouth");
        this.leftFin = this.body.m_171324_("left_fin");
        this.rightFin = this.body.m_171324_("right_fin");
        this.tailFin = this.tail.m_171324_("tail_fin");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -6.0f, -12.0f, 7.0f, 10.0f, 22.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-1.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, -3.0f, 0.0f, 4.0f, 6.0f, 6.0f).m_171514_(0, 0).m_171481_(0.0f, 3.0f, 0.0f, 0.0f, 1.0f, 5.0f).m_171514_(0, 1).m_171481_(0.0f, -4.0f, 0.0f, 0.0f, 1.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)10.0f));
        PartDefinition tailFin = tail.m_171599_("tail_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -9.0f, -1.0f, 0.0f, 15.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        PartDefinition dorsalFin = body.m_171599_(DORSAL_FIN, CubeListBuilder.m_171558_().m_171514_(14, 25).m_171481_(0.0f, -4.0f, -3.5f, 0.0f, 4.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-2.5f));
        PartDefinition dorsalFin2 = body.m_171599_(DORSAL_FIN2, CubeListBuilder.m_171558_().m_171514_(10, 0).m_171481_(0.0f, -2.0f, -2.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)6.0f));
        PartDefinition leftPectoralFin = body.m_171599_(LEFT_PECTORAL_FIN, CubeListBuilder.m_171558_().m_171514_(14, 3).m_171481_(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 3.0f), PartPose.m_171419_((float)1.5f, (float)4.0f, (float)0.5f));
        PartDefinition rightPectoralFin = body.m_171599_(RIGHT_PECTORAL_FIN, CubeListBuilder.m_171558_().m_171514_(14, 3).m_171481_(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-1.5f, (float)4.0f, (float)0.5f));
        PartDefinition pelvicFin = body.m_171599_(PELVIC_FIN, CubeListBuilder.m_171558_().m_171514_(14, 6).m_171481_(0.0f, 0.0f, -1.5f, 0.0f, 2.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)6.5f));
        PartDefinition mouth = body.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171481_(-2.5f, -8.0f, -1.0f, 5.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-12.0f));
        PartDefinition leftFin = body.m_171599_("left_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(0.0f, 0.0f, -2.0f, 5.0f, 0.0f, 4.0f).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)2.0f, (float)-5.0f));
        PartDefinition rightFin = body.m_171599_("right_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, 0.0f, -2.0f, 5.0f, 0.0f, 4.0f), PartPose.m_171419_((float)-3.5f, (float)2.0f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Tuna entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float speed = 1.2f;
        float degree = 1.5f;
        float pi = (float)Math.PI;
        this.body.f_104203_ = headPitch * (pi / 180.0f);
        this.body.f_104204_ = headYaw * (pi / 180.0f);
        this.body.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * 1.5f * 0.25f + 20.0f;
        this.body.f_104204_ += Mth.m_14089_((float)(animationProgress * speed * 0.4f + 2.0f)) * degree * 0.4f * 0.25f;
        this.body.f_104203_ += Mth.m_14089_((float)(animationProgress * speed * 0.2f + 2.0f)) * degree * 0.1f * 0.25f;
        this.tail.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 1.0f)) * degree * 0.8f * 0.25f;
        this.tailFin.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f)) * degree * 1.6f * 0.25f;
        this.mouth.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.1f)) * degree * 0.1f * 0.25f + 0.05f;
        this.rightFin.f_104205_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 1.0f)) * degree * 0.8f * 0.25f - 0.4f;
        this.rightFin.f_104204_ = 0.4f;
        this.leftFin.f_104205_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 1.0f + pi)) * degree * 0.8f * 0.25f + 0.4f;
        this.leftFin.f_104204_ = -0.4f;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }
}

